import numpy as np
import matplotlib.pyplot as plt

# 随机生成非均匀分布的 x, y 坐标
np.random.seed(0)
x = np.random.uniform(0, 10, 100)
y = np.random.uniform(0, 10, 100)

# 为每一对 (x, y) 坐标生成对应的 z 值
z = np.sin(x) + np.cos(y)

# 创建 1x3 子图
fig, axes = plt.subplots(1, 3, figsize=(18, 6))

# 方法 1: 使用 scatter 绘制散点热力图
axes[0].scatter(x, y, c=z, cmap='viridis')
axes[0].set_xlabel('X Axis')
axes[0].set_ylabel('Y Axis')
axes[0].set_title('Scatter Plot Heatmap')
fig.colorbar(axes[0].collections[0], ax=axes[0])

# 方法 2: 使用 hist2d 绘制二维直方图热力图
axes[1].hist2d(x, y, bins=(20, 20), cmap='viridis')
axes[1].set_xlabel('X Axis')
axes[1].set_ylabel('Y Axis')
axes[1].set_title('2D Histogram Heatmap')
fig.colorbar(axes[1].collections[0], ax=axes[1])

# 方法 3: 使用 tricontourf 绘制等高线热力图
axes[2].tricontourf(x, y, z, cmap='viridis')
axes[2].set_xlabel('X Axis')
axes[2].set_ylabel('Y Axis')
axes[2].set_title('Contour Heatmap')
fig.colorbar(axes[2].collections[0], ax=axes[2])

# 调整布局，避免子图之间重叠
plt.tight_layout()

# 保存图像到文件
plt.savefig('heatmap_comparison.png')  # 保存为 PNG 格式
# 如果你需要保存为其他格式，调整文件扩展名即可，比如 'heatmap_comparison.pdf' 或 'heatmap_comparison.svg'

# 显示图形
plt.show()